<?php

declare(strict_types=1);

namespace Drupal\meeting_api;

use Drupal\Component\Plugin\ConfigurableInterface;
use Drupal\Component\Plugin\DerivativeInspectionInterface;
use Drupal\Core\Plugin\PluginWithFormsInterface;

/**
 * Interface for meeting_api_backend plugins.
 */
interface BackendInterface extends ConfigurableInterface, DerivativeInspectionInterface, PluginWithFormsInterface {

  /**
   * The plugin form key for the "configure" operation.
   *
   * @see \Drupal\Core\Plugin\PluginWithFormsInterface
   */
  public const PLUGIN_FORM_CONFIGURE = 'configure';

  /**
   * The plugin form key for the "meeting" operation.
   *
   * Used for retrieving the configuration form of a backend plugin in the
   * context of a single meeting.
   */
  public const PLUGIN_FORM_MEETING = 'meeting';

  /**
   * Returns the translated plugin label.
   */
  public function label(): string;

  /**
   * Joins a user to a meeting.
   *
   * @param \Drupal\meeting_api\MeetingInterface $meeting
   *   The meeting to join to.
   * @param \Drupal\meeting_api\MeetingAttendeeInterface $user
   *   The user to join the meeting.
   *
   * @return string
   *   The URL of the meeting.
   *
   * @throws \Drupal\meeting_api\Exception\OperationException
   *   Thrown when the operation fails.
   */
  public function joinMeeting(MeetingInterface $meeting, MeetingAttendeeInterface $user): string;

}
