<?php

declare(strict_types=1);

namespace Drupal\meeting_api;

use Drupal\user\UserInterface;

/**
 * Base class for users in meetings.
 */
class MeetingAttendee implements MeetingAttendeeInterface {

  public function __construct(
    protected readonly UserInterface $user,
    protected readonly string $role,
  ) {}

  /**
   * {@inheritdoc}
   */
  public function getId(): string {
    // @todo uuid or id? Not used yet.
    return $this->user->uuid();
  }

  /**
   * {@inheritdoc}
   */
  public function getName(): string {
    $display_name = $this->user->getDisplayName() ?? '';
    // We want to use trimmed version of the name to avoid extra spaces.
    return trim((string) $display_name);
  }

  /**
   * {@inheritdoc}
   */
  public function getMeetingRole(): string {
    return $this->role;
  }

}
