<?php

declare(strict_types=1);

namespace Drupal\meeting_api_test\Plugin\MeetingApiBackend;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\meeting_api\Attribute\Backend;
use Drupal\meeting_api_test\PluginForm\AcmeMeetingConfigurationForm;
use Drupal\meeting_api_test\PluginForm\AcmeServerConfigurationForm;

/**
 * A test plugin named Acme.
 *
 * It offers dedicated server and meeting configuration form classes.
 */
#[Backend(
  id: 'acme',
  label: new TranslatableMarkup('Acme'),
  description: new TranslatableMarkup('Acme description.'),
  forms: [
    'configure' => AcmeServerConfigurationForm::class,
    'meeting' => AcmeMeetingConfigurationForm::class,
  ]
)]
final class Acme extends TestBackendBase {

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration(): array {
    return [
      'url' => '',
      'key' => '',
      'mode' => NULL,
    ];
  }

}
