<?php

declare(strict_types=1);

namespace Drupal\meeting_api_test\PluginForm;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Plugin\PluginFormBase;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\meeting_api\BackendInterface;
use Drupal\meeting_api\MeetingInterface;

/**
 * Configuration form for the "meeting" action of acme backend.
 */
class AcmeMeetingConfigurationForm extends PluginFormBase {

  use StringTranslationTrait;

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
    $entity = $form_state->get('meeting_entity');
    assert($entity instanceof MeetingInterface);
    $configuration = $entity->getSettings();

    $form['record'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Record meeting'),
      '#default_value' => $configuration['record'] ?? FALSE,
    ];

    // Test that the plugin is correctly passed to the form by exposing one of
    // its configuration.
    assert($this->plugin instanceof BackendInterface);
    $form['mode_set'] = [
      '#type' => 'container',
      'value' => [
        '#plain_text' => $this->plugin->getConfiguration()['mode'],
      ],
      '#attributes' => [
        'data-test-attribute' => 'mode-set',
      ],
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state) {
    $form_state->setValue('record', (bool) $form_state->getValue('record'));
  }

}
