<?php

namespace Drupal\meeting_api_bbb;

/**
 * Client factory interface for creating BBB clients.
 */
interface ClientFactoryInterface {

  /**
   * Returns a new instance of a BBB client.
   *
   * @param string $url
   *   The URL of the server.
   * @param string $secret
   *   The secret used in requests.
   * @param array $config
   *   The config for the HTTP client.
   *
   * @return \Drupal\meeting_api_bbb\BigBlueButtonClient
   *   The BigBlueButton client.
   */
  public function createClient(string $url, string $secret, array $config = []): BigBlueButtonClient;

}
