<?php

declare(strict_types=1);

namespace Drupal\meeting_api_bbb\PluginForm;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Plugin\PluginFormBase;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\meeting_api\BackendInterface;

/**
 * Configuration form for the "configure" operation of bigbluebutton backend.
 */
class BigBlueButtonServerConfigurationForm extends PluginFormBase {

  use StringTranslationTrait;

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state): array {
    assert($this->plugin instanceof BackendInterface);
    $configuration = $this->plugin->getConfiguration();

    // @todo Add better descriptions of the expected values.
    $form['url'] = [
      '#type' => 'url',
      '#title' => $this->t('Server URL'),
      '#required' => TRUE,
      '#default_value' => $configuration['url'],
    ];

    $form['key'] = [
      '#type' => 'key_select',
      '#title' => $this->t('Key'),
      '#required' => TRUE,
      '#default_value' => $configuration['key'],
      '#key_filters' => ['type' => 'authentication'],
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function validateConfigurationForm(array &$form, FormStateInterface $form_state) {
    // No validation needed.
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state): void {
    $configuration = [];
    $configuration['url'] = $form_state->getValue('url');
    $configuration['key'] = $form_state->getValue('key');

    assert($this->plugin instanceof BackendInterface);
    $this->plugin->setConfiguration($configuration);
  }

}
