# Meeting API BigBlueButton

⚠️ **Module on current development** ⚠️

The module provides a backend plugin to create meetings in [BigBlueButton](https://bigbluebutton.org/).

In order to use the plugin, you need a BigBlueButton server URL and key.

## Requirements

This module requires the following other modules:

- [meeting_api](https://www.drupal.org/project/meeting_api)

## Installation

Install as you would normally install a contributed Drupal module. For further
information, see
[Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

## Contributing

[DDEV](https://ddev.com), a Docker-based PHP development tool for a streamlined
and unified development process, is the recommended tool for contributing to the
module. The [DDEV Drupal Contrib](https://github.com/ddev/ddev-drupal-contrib)
addon makes it easy to develop a Drupal module by offering the tools to set up
and test the module.

### Development configuration

Inside the cloned project run:

```shell
# Fire up the Docker containers.
ddev start
# Install the PHP dependencies.
ddev poser
# Symlink the module inside "web/modules/custom".
ddev symlink-project
# Install Drupal and enable the module.
ddev install
# Run this if you want to use the eslint command.
ddev exec "cd web/core && yarn install"
```

### Changing the Drupal core version

- Create a file`.ddev/config.local.yaml`
- Set the desired Drupal core version. E.g.:

  ```yaml
  web_environment:
    - DRUPAL_CORE=^10.3
  ```

- Run`ddev restart`

### Run tests

```shell
# Run PHPUnit tests.
ddev phpunit
# Run PHP coding standards checks.
ddev phpcs
# Fix coding standards findings.
ddev phpcbf
# Run PHP static analysis.
ddev phpstan
# Run ESLint on Javascript and YAML files.
ddev eslint
```
