<?php

declare(strict_types=1);

namespace Drupal\meeting_api_bbb;

use Drupal\Core\Http\ClientFactory as HttpClientFactory;

/**
 * Helper class to construct a BigBlueButtonClient specific config.
 */
class ClientFactory implements ClientFactoryInterface {

  public function __construct(
    protected HttpClientFactory $httpClientFactory,
  ) {}

  /**
   * {@inheritdoc}
   */
  public function createClient(string $url, string $secret, array $config = []): BigBlueButtonClient {
    $http_client = $this->httpClientFactory->fromOptions($config);

    return new BigBlueButtonClient($url, $secret, $http_client);
  }

}
