# Mentions Tagify

Adds Tagify autocomplete UI for the Mentions module to textareas via mentions text input filter. Provides a modern autocomplete interface featuring rich dropdowns with user avatars and additional info.

## Features

* Type `@` in textareas to trigger user autocomplete
* Rich dropdown with avatars and custom info labels
* Choose from role-based filtering or Views integration to limit which users appear in the autocomplete
* Per-text-format configuration via input filter settings
* Integrates with Mentions module for rendering and mention tracking

## Requirements

This module requires the following modules:

* [Mentions](https://www.drupal.org/project/mentions)
* [Tagify](https://www.drupal.org/project/tagify)
* [Tagify User List](https://www.drupal.org/project/tagify_user_list)

## Installation

Install as you would normally install a contributed Drupal module. For further information, see [Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

## Configuration

1. **Configure Mentions module** with a UserMention type at `/admin/structure/mentions`
   * Recommended format: `[@user_id]`
   
2. **Enable Mentions Filter** in your text format at `/admin/config/content/formats`
   * Configure the Mentions Filter settings
   
3. **Configure Mentions Tagify** autocomplete options in the filter settings
   * Choose user selection method (Role-based or Views)
   * Configure avatars and info labels
   * Set autocomplete behavior

4. Users can now type `@` in textareas to trigger autocomplete

## Important Limitations

**This module is in early development stage with significant limitations:**

* **User mentions only** - No support for node mentions, taxonomy mentions, or other entity types
* **Plain textareas only** - NOT tested with CKEditor, TinyMCE, or other WYSIWYG editors
* **Format constraints** - Works best with `[@user_id]` format. Other formats should work but results will vary
* **Alpha quality** - Limited testing. Use with caution in production

## Future Plans

* Support other entity type mentions such as nodes (`#123`)
* WYSIWYG editor support
* Support multiple mention types on same field

## Supporting this Module

Patches and suggestions welcome in the [issue queue](https://www.drupal.org/project/issues/mentions_tagify).

## Maintainers

* Loze - https://drupal.org/u/loze
