<?php

namespace Drupal\mentions_tagify\Controller;

use Drupal\tagify\Controller\TagifyEntityAutocompleteController;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Defines a route controller for mentions tagify autocomplete.
 *
 * Extends the base Tagify controller to use tagify_user_list matcher.
 * This provides rich user autocomplete (avatars, roles, views) while
 * outputting format compatible with Mentions module (@username).
 */
class MentionsTagifyEntityAutocompleteController extends TagifyEntityAutocompleteController {

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('mentions_tagify.autocomplete_matcher')
    );
  }

}
