<?php

namespace Drupal\Tests\menu_child_item\Functional;

use Drupal\menu_link_content\Entity\MenuLinkContent;
use Drupal\Core\Url;
use Drupal\Tests\BrowserTestBase;
use Drupal\user\UserInterface;

/**
 * Simple test to ensure that main page loads with module enabled.
 *
 * @group menu_child_item
 */
class LoadTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * Modules to enable.
   *
   * @var array
   */
  protected static $modules = ['menu_child_item'];

  /**
   * A user with permission to administer menu and link to any page.
   *
   * @var \Drupal\user\UserInterface
   */
  protected UserInterface $adminUser;

  /**
   * A user with permission to administer menus only.
   *
   * @var \Drupal\user\UserInterface
   */
  protected UserInterface $basicUser;

  /**
   * A user with no menu permissions.
   *
   * @var \Drupal\user\UserInterface
   */
  protected UserInterface $authUser;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->adminUser = $this->drupalCreateUser(['administer menu', 'link to any page']);
    $this->basicUser = $this->drupalCreateUser(['administer menu']);
    $this->authUser = $this->drupalCreateUser([]);
    $this->drupalLogin($this->adminUser);
  }

  /**
   * Tests that the home page loads with a 200 response.
   */
  public function testLoad(): void {
    $this->drupalGet(Url::fromRoute('<front>'));
    $this->assertSession()->statusCodeEquals(200);
  }

  /**
   * Tests for adding Child Menu with various users.
   */
  public function testAddingChildMenu(): void {
    $menu_link = MenuLinkContent::create([
      'title' => 'Menu link test',
      'provider' => 'menu_link_content',
      'menu_name' => 'admin',
      'link' => ['uri' => 'internal:/user/login'],
    ]);
    $menu_link->save();

    $this->drupalGet('/admin/structure/menu/item/' . $menu_link->id() . '/add-child');
    $this->assertSession()->statusCodeEquals(200);

    $this->drupalLogin($this->basicUser);
    $this->drupalGet('/admin/structure/menu/item/' . $menu_link->id() . '/add-child');
    $this->assertSession()->statusCodeEquals(200);

    $this->drupalLogin($this->authUser);
    $this->drupalGet('/admin/structure/menu/item/' . $menu_link->id() . '/add-child');
    $this->assertSession()->statusCodeEquals(403);
  }

}
