<?php

/**
 * @file
 * Hooks to alter menu export CSV header and rows.
 */

declare(strict_types=1);

/**
 * @addtogroup hooks
 * @{
 */

/**
 * Allows modification of the  header in the menu export CSV.
 *
 * @param array &$header
 *   The CSV header array.
 * @param array $context
 *   Additional context, including 'menu'.
 */
function hook_menu_export_csv_header_alter(array &$header, array $context) {
  // Example: Add a custom column.
  $header[] = 'custom_column';
}

/**
 * Allows modification of the rows in the menu export CSV.
 *
 * @param array &$row
 *   The row data array.
 * @param array $context
 *   Additional context, including 'menu' and element-specific data.
 */
function hook_menu_export_csv_row_alter(array &$row, array $context) {
  // Example: Add a custom row value.
  $row['custom_column'] = t('Custom Value');
}

/**
 * @} End of "addtogroup hooks".
 */
