<?php

declare(strict_types=1);

namespace Drupal\Tests\menu_export_csv\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * Test Menu Export CSV.
 *
 * @group menu_export_csv
 */
class MenuExportCsvTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['menu_export_csv'];

  /**
   * Test Menu Export CSV.
   */
  public function testMenuExportCsv(): void {
    global $base_url;
    $assert = $this->assertSession();

    $this->drupalLogin($this->drupalCreateUser(['administer menu']));

    // Check that the Download CSV link exists.
    $this->drupalGet('/admin/structure/menu/manage/admin');
    $assert->responseContains('<u>⇩</u> Download CSV');

    // Check the download.
    $this->drupalGet('/admin/structure/menu/manage/admin/download');
    $assert->responseContains(' - Administration",1,Administration,,' . $base_url . '/admin,Yes,No,,,,system.admin,system');
    $assert->responseContains(' - - Content",2,Content,"Find and manage content.",' . $base_url . '/admin/content,Yes,No,,,,system.admin_content,system');
    $assert->responseContains(' - - Structure",2,Structure,"Administer blocks, content types, menus, etc.",' . $base_url . '/admin/structure,Yes,No,,,,system.admin_structure,system');
  }

}
