<?php

namespace Drupal\menu_family\FamilyRelation;

/**
 * Provides functionality to find previous and next menu items in a family.
 */
class PreviousNext extends Related {

  /**
   * {@inheritdoc}
   */
  protected function getRelateds(): array {
    $menu_link = $this->findNodeMenuLinkContent($this->currentNodeId);

    if ($menu_link === NULL || $menu_link->getParent() === NULL) {
      return [];
    }

    $menu_entries = $this->getChildrenMenuEntries($menu_link->getParent());
    $current_menu_entry =
      (string) $this->getMenuEntry($menu_link->getPluginId());

    // Find the current menu entry index.
    $current_index = NULL;
    $indexes = array_keys($menu_entries);
    foreach ($indexes as $index => $key) {
      if ($menu_entries[$key] === $current_menu_entry) {
        $current_index = $index;
        break;
      }
    }

    if ($current_index === NULL) {
      return [0 => NULL, 1 => NULL, 2 => NULL];
    }

    $result = [];

    // Add previous menu entry.
    if ($current_index > 0) {
      $result[] = $menu_entries[$indexes[$current_index - 1]];
    }
    else {
      $result[] = NULL;
    }

    // Add current menu entry.
    $result[] = $menu_entries[$indexes[$current_index]];

    // Add next menu entry.
    if ($current_index < count($indexes) - 1) {
      $result[] = $menu_entries[$indexes[$current_index + 1]];
    }
    else {
      $result[] = NULL;
    }

    return $result;
  }

}
