<?php

namespace Drupal\menu_family\Enum;

/**
 * Enum representing the relation between two menu entries.
 */
enum FamilyRelation: string {
  case Children = 'menu_family_children';
  case Siblings = 'menu_family_siblings';
  case PreviousNext = 'menu_family_previous_next';

  /**
   * Get all the cases' values.
   *
   * @return array
   *   The cases' values.
   */
  public static function values(): array {
    return array_map(fn ($case) => $case->value, self::cases());
  }

  /**
   * Get the name of the corresponding display mode.
   *
   * @return string
   *   The name of the display mode.
   */
  public function displayModeName(): string {
    return match ($this) {
      self::Children => 'children_display_mode',
      self::Siblings => 'siblings_display_mode',
      self::PreviousNext => 'previous_next_display_mode',
    };
  }

}
