<?php

namespace Drupal\menu_level_permission\Controller;

use Drupal\Core\Controller\ControllerBase;

/**
 * Class for building the menu overview page with restricted permissions.
 */
class MenuLevelPermissionController extends ControllerBase {

  /**
   * Constructs menus overview page.
   */
  public function menuOverviewPage() {
    // Get initial list of allowed menus.
    // Take into account menu_admin_per_menu module restrictions if it exists.
    if ($this->moduleHandler()->moduleExists('menu_admin_per_menu')) {
      // Avoid a dependency on menu_admin_per_menu.
      // @phpcs:disable
      // @phpstan-ignore-next-line
      $menu_admin_per_menu_controller = new \Drupal\menu_admin_per_menu\Controller\MenuAdminPerMenuController(
        // @phpstan-ignore-next-line
        \Drupal::service('menu_admin_per_menu.allowed_menus')
      );
      // @phpcs:enable
      $menu_table = $menu_admin_per_menu_controller->menuOverviewPage();
    }
    else {
      $menu_table = $this->entityTypeManager()->getListBuilder('menu')->render();
    }

    // Only alter if user does not have administer restricted menu levels.
    $account = $this->currentUser();
    if ($account->hasPermission('administer restricted menu levels')) {
      return $menu_table;
    }

    $config = $this->config('menu_level_permission.settings');
    $restricted_menus = $config->get('restricted_menus');

    foreach ($menu_table['table']['#rows'] as $menu_key => $menu_item) {
      if (!isset($restricted_menus[$menu_key]) || !$restricted_menus[$menu_key]) {
        // If the menu is not restricted, no need to validate.
        continue;
      }

      // Remove the add child operation.
      unset($menu_table['table']['#rows'][$menu_key]['operations']['data']['#links']['add']);
    }
    return $menu_table;
  }

}
