<?php

namespace Drupal\menu_level_permission\Routing;

use Drupal\Core\Routing\RouteSubscriberBase;
use Drupal\Core\Routing\RoutingEvents;
use Symfony\Component\Routing\RouteCollection;

/**
 * Listens to the dynamic route events.
 */
class RouteSubscriber extends RouteSubscriberBase {

  /**
   * {@inheritdoc}
   */
  protected function alterRoutes(RouteCollection $collection) {
    $routes = $collection->all();
    foreach ($routes as $route_name => $route) {
      switch ($route_name) {
        case 'entity.menu.collection':
          $route->setDefaults([
            '_title' => $route->getDefault('_title'),
            '_controller' => '\Drupal\menu_level_permission\Controller\MenuLevelPermissionController::menuOverviewPage',
          ]);
          break;

        case 'entity.menu_link_content.canonical':
        case 'entity.menu_link_content.delete_form':
        case 'entity.menu_link_content.content_translation_overview':
        case 'entity.menu_link_content.content_translation_add':
        case 'entity.menu_link_content.content_translation_edit':
        case 'entity.menu_link_content.content_translation_delete':
          $route->setRequirements(['_custom_access' => '\Drupal\menu_level_permission\Access\MenuLevelPermissionAccess::menuItemAccess']);
          break;
      }
    }
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    // Run after menu_admin_per_menu, which has priority -220.
    $events[RoutingEvents::ALTER] = ['onAlterRoutes', -230];
    return $events;
  }

}
