# Menu Link Content Revisions UI

Menu link content in Drupal core was made revision-able in https://www.drupal.org/node/3039034 but core does not include a UI. This module exposes a minimal UI for menu link content revisions. 

## Features
This project provides a revisions tab with a revisions log when editing individual menu link content items and a "Revisions" operation link to the new revision log.

## Post-Installation
Once installed, menu link content items will have a revisions tab. (Note: not all menu links are menu link content; some links are defined by modules or profiles and are not revision-able content.) However, currently there's no way in the interface to configure menu link content to create new revisions by default. This module provides a setting that creates automatic revisions on menu link content when they are saved. 

Users of this module can either enable the automatic revisions in the module settings at /admin/config/user-interface/menu-link-content-revisions-ui or implement their own solution so that new useful revisions are created when editing menu link content.

## Warning for sites upgraded from a version prior to Drupal 8.7

Warning: if your site was upgraded from a prior version of Drupal before menu link content was made revision-able, and you have menu items that date back to that time, you may experience an issue where the revision created date for a menu link item is NULL. This will cause a PHP error when viewing the revisions log because Drupal core does not check that a timestamp is valid before trying to format it. The solution can be to set the revision created date for items with a null date to the last menu link changed date using a query:


    UPDATE menu_link_content_revision
      INNER JOIN menu_link_content_data
      ON menu_link_content_data.revision_id = menu_link_content_revision.revision_id 
      SET menu_link_content_revision.revision_created = menu_link_content_data.changed 
      WHERE menu_link_content_revision.revision_created IS NULL;
