<?php

namespace Drupal\menu_link_content_revisions_ui\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\ConfigTarget;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Form\RedundantEditableConfigNamesTrait;

/**
 * Form for configuring menu link content revisions UI settings.
 *
 * @package Drupal\menu_link_content_revisions_ui\Form
 */
class MenuLinkContentRevisionsUiSettingsForm extends ConfigFormBase {
  use RedundantEditableConfigNamesTrait;

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [
      'menu_link_content_revisions_ui.settings',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'menu_link_content_revisions_ui_settings';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form['enable_auto_revisions'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable automatic revisions on every menu link content save.'),
      '#config_target' => new ConfigTarget(
        'menu_link_content_revisions_ui.settings',
        'enable_auto_revisions',
      ),
      '#description' => $this->t('Automatically create a new revision every time a menu link content item is saved. For menu links in node forms, only create a new revision if the menu link has changed. If not enabled, you will need another method to create revisions.'),
    ];
    $form['log_messages'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('Customize Revision Log Messages'),
      '#description' => $this->t('If automatic revisions are enabled, customize the revision log messages.'),
      '#description_display' => 'before',
      '#collapsible' => TRUE,
      '#collapsed' => FALSE,
    ];
    $form['log_messages']['append_menu_link_status'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Append menu link status to log message.'),
      '#config_target' => new ConfigTarget(
        'menu_link_content_revisions_ui.settings',
        'append_menu_link_status',
      ),
      '#description' => $this->t('Append the menu link status to the revision log message - enabled or disabled.'),
    ];
    $form['log_messages']['node_add_message'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Message when a new link is added via the node form.'),
      '#config_target' => new ConfigTarget(
        'menu_link_content_revisions_ui.settings',
        'node_add_message',
      ),
      '#maxlength' => 255,
      '#required' => TRUE,
    ];
    $form['log_messages']['node_update_message'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Message when a link is updated via the node form.'),
      '#config_target' => new ConfigTarget(
        'menu_link_content_revisions_ui.settings',
        'node_update_message',
      ),
      '#maxlength' => 255,
      '#required' => TRUE,
    ];
    $form['log_messages']['menu_edit_message'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Message when a link is updated in bulk on the menu form.'),
      '#config_target' => new ConfigTarget(
        'menu_link_content_revisions_ui.settings',
        'menu_edit_message',
      ),
      '#maxlength' => 255,
      '#required' => TRUE,
    ];
    $form['log_messages']['menu_link_add_message'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Message when a new link is added via the menu link content form.'),
      '#config_target' => new ConfigTarget(
        'menu_link_content_revisions_ui.settings',
        'menu_link_add_message',
      ),
      '#maxlength' => 255,
      '#required' => TRUE,
    ];
    $form['log_messages']['menu_link_update_message'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Message when a link is updated via the menu link content form.'),
      '#config_target' => new ConfigTarget(
        'menu_link_content_revisions_ui.settings',
        'menu_link_update_message',
      ),
      '#maxlength' => 255,
      '#required' => TRUE,
    ];

    return parent::buildForm($form, $form_state);
  }

}
