<?php

/**
 * @file
 * Hooks provided by the Menu Link View Count module.
 */

/**
 * Allow moules and themes to alter the menu link view count rendering.
 *
 * @param array $data
 *   Data for use to alter the menu link view count rendering. Elements
 *   include:
 *   - title: The original link text.
 *   - count: The count to be displayed, note this may be limited per the
 *     configured limit.
 *   - total_rows: The raw number of total rows as provided by the view.
 *   - count_template: A string of markup with placeholders for rendering the
 *     count. The count's placeholder is @count.
 *   - title_template: A string with placeholders for rendering the link title
 *     along with the count's markup. The title's placeholder is @title and the
 *     count element's placeholder is @count_element.
 *   - view: The executed view that provided the count.
 *   - view_display: A string comprised of the configured view and display in
 *     the format of "<view_id>:<display>".
 *   - cache: A BubbleableMetadata object to allow cache and attachments to be
 *     manipulated.
 *   - options: An array of the link options.
 *   - container_class: A class to add to the menu link container (<li>).
 *   - attach_library: Allows the CSS/JS library to be omitted.
 *   - omit: Omit the counter rendering. This will already be populated to
 *     consider the "omit empty" option. The container_class will not be set
 *     and the library will not be attached if the count is omitted.
 * @param array $item
 *   The menu item.
 */
function hook_menu_link_view_count_alter(array &$data, array &$item) {
  // Add 10 to the count, note this will override the configured count limit.
  $data['count'] = $data['total_rows'] + 10;

  // Custom class for the container.
  $data['container_class'] = 'contains-count';

  // Skip the count on Mondays. Should also set additional cache meta to
  // invalidate based on time and user timezone.
  $data['omit'] = date('w') == 1;

  // Omit the default styles included with this module.
  $data['attach_library'] = FALSE;
}
