# Menu Markdown Token

Provides tokens that output menu hierarchies in markdown format.

## Installation

1. Enable the module: `drush en menu_markdown_token`
2. Clear cache: `drush cr`

## Usage

The module provides a dynamic token type `[menu-markdown]` that accepts menu machine names and optional depth parameters.

### Token Syntax

```
[menu-markdown:MENU_MACHINE_NAME]
[menu-markdown:MENU_MACHINE_NAME:DEPTH]
```

### Parameters

- **MENU_MACHINE_NAME** (required): The machine name of the menu
- **DEPTH** (optional): Maximum depth to traverse. Defaults to 10 if not specified.

### Examples

```
[menu-markdown:main]          # Main menu with default depth of 10
[menu-markdown:main:5]        # Main menu limited to 5 levels
[menu-markdown:footer]        # Footer menu with default depth
[menu-markdown:footer:3]      # Footer menu limited to 3 levels
[menu-markdown:account:2]     # Account menu limited to 2 levels
```

## Output Format

The token outputs a hierarchical markdown list with proper indentation (2 spaces per level):

```markdown
- [Home](/)
- [About](/about)
  - [Our Team](/about/team)
  - [History](/about/history)
- [Services](/services)
  - [Hosting](/services/hosting)
    - [WebOps](/services/hosting/webops)
  - [Support](/services/support)
```

## Use Cases

- API responses requiring menu structure
- Integration with LLM prompts and Agentic Systems
- Documentation generation
- Content exports
- Integration with external systems

## Features

- **Hierarchical output**: Maintains menu parent-child relationships
- **Access control**: Respects menu item permissions (hidden items are excluded)
- **Multiple URL types**: Handles internal routes, external URLs, and special routes
- **Depth control**: Configurable traversal depth via token parameter
- **Caching**: Properly cached with menu and language cache tags
- **Special route handling**:
  - `<front>` renders as `/`
  - `<nolink>` and `<button>` render as plain text without URL
  - External URLs preserved as-is

## Technical Details

### Services

- `menu_markdown_token.generator`: Core service for generating markdown from menu trees

### Cache Tags

- `config:system.menu.{menu_name}`: Invalidates when menu configuration changes

### Cache Contexts

- `languages:language_interface`: Varies by active language

## Error Handling

- Invalid menu names return empty string and log a warning
- Inaccessible menu items are skipped
- Failed URL generation is handled gracefully

## Requirements

- Drupal 9, 10, or 11
- No additional dependencies (uses core menu system)
