/**
 * @file
 * Behavior which initializes the select_extractor library for the menu node form
 */
(function (Drupal, drupalSettings, once) {
  'use strict';

  Drupal.behaviors.menu_parent_form_ui = {
    attach: function (context) {
      once('menu_parent_form_ui', 'html', context).forEach(function () {
        // This is the menu content link form.
        if (document.getElementById('edit-menu-parent')) {
          var select_extract_menu_form = new SelectExtractor(
            {
              selectors: {
                select_input_original: '#edit-menu-parent',
                select_box_container: '.form-item--menu-parent',
                active_set: drupalSettings.active_set,
              }
            }
          );
        }
        // This is the node form.
        else {
          var select_extract_node_form = new SelectExtractor(
            {
              selectors: {
                select_input_original: '#edit-menu-menu-parent',
                select_box_container: '.form-item--menu-menu-parent',
                active_set: drupalSettings.active_set,
              }
            }
          );
        }
      });
    }
  };

})(Drupal, drupalSettings, once);
