/* global SelectExtractor */
/**
 * @file
 * Initializes the select_extractor library for the menu link and node forms.
 */
(function (Drupal, drupalSettings, once) {
  Drupal.behaviors.menu_parent_form_ui = {
    attach(context) {
      once('menu_parent_form_ui', 'html', context).forEach(function () {
        // Only create the new select dropdowns if the wrapper element exists.
        // This is the menu content link form.
        if (
          document.querySelector(
            drupalSettings.menu_link_content_form_wrapper_selector,
          )
        ) {
          new SelectExtractor({
            selectors: {
              select_input_original: '#edit-menu-parent',
              select_box_container:
                drupalSettings.menu_link_content_form_wrapper_selector,
              active_set: drupalSettings.active_set,
            },
          });
        }
        // This is the node form.
        else if (
          document.querySelector(drupalSettings.node_form_wrapper_selector)
        ) {
          new SelectExtractor({
            selectors: {
              select_input_original: '#edit-menu-menu-parent',
              select_box_container: drupalSettings.node_form_wrapper_selector,
              active_set: drupalSettings.active_set,
            },
          });
        }
      });
    },
  };
})(Drupal, drupalSettings, once);
