<?php

namespace Drupal\menu_parent_form_ui\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\ConfigTarget;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Form\RedundantEditableConfigNamesTrait;

/**
 * Form for configuring menu parent form UI settings.
 *
 * @package Drupal\menu_parent_form_ui\Form
 */
class MenuParentFormUiSettingsForm extends ConfigFormBase {
  use RedundantEditableConfigNamesTrait;

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [
      'menu_parent_form_ui.settings',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'menu_parent_form_ui_settings';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form['menu_link_content_form_wrapper_selector'] = [
      '#type' => 'textfield',
      '#title' => $this->t('CSS Selector for the wrapper parent element on the menu link content form'),
      '#description' => $this->t('This determines where the new select element is added in the menu link content form. It defaults to the class used by the Claro theme. If NOT using Claro to display the form, customize this value.'),
      '#config_target' => new ConfigTarget(
        'menu_parent_form_ui.settings',
        'menu_link_content_form_wrapper_selector',
      ),
      '#maxlength' => 255,
      '#required' => TRUE,
    ];
    $form['node_form_wrapper_selector'] = [
      '#type' => 'textfield',
      '#title' => $this->t('CSS Selector for the wrapper menu parent element on the node form'),
      '#description' => $this->t('This determines where the new select element is added in the node form. It defaults to the class used by the Claro theme. If NOT using Claro to display the form, customize this value.'),
      '#config_target' => new ConfigTarget(
        'menu_parent_form_ui.settings',
        'node_form_wrapper_selector',
      ),
      '#maxlength' => 255,
      '#required' => TRUE,
    ];

    return parent::buildForm($form, $form_state);
  }

}
