<?php

namespace Drupal\Tests\menu_parent_form_ui\FunctionalJavascript;

use Drupal\FunctionalJavascriptTests\WebDriverTestBase;

/**
 * Test settings page.
 *
 * @group menu_parent_form_ui
 */
class MenuParentFormUiSettingsTest extends WebDriverTestBase {

  /**
   * The default theme - not Claro.
   *
   * @var string
   */
  protected $defaultTheme = 'stark';

  /**
   * The installation profile.
   *
   * @var string
   */
  protected $profile = 'standard';

  /**
   * User with admin privileges.
   *
   * @var \Drupal\user\UserInterface
   */
  protected $adminUser;

  /**
   * The modules to load to run the test.
   *
   * @var array
   */
  protected static $modules = ['user', 'node', 'menu_parent_form_ui'];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    // Create admin user.
    $this->adminUser = $this->drupalCreateUser([
      'administer site configuration',
      'administer menu',
      'administer nodes',
      'create page content',
      'edit any page content',
    ]);

    // Login.
    $this->drupalLogin($this->adminUser);
  }

  /**
   * Change CSS selectors to match Stark classes.
   */
  protected function testSettingsForm() {
    // Navigate to the settings form.
    $this->drupalGet('admin/config/user-interface/menu-parent-form-ui');

    // Modify CSS selectors for wrappers to match Stark theme.
    $page = $this->getSession()->getPage();
    $page->fillField('menu_link_content_form_wrapper_selector', '.form-item-menu-parent');
    $page->fillField('node_form_wrapper_selector', '.form-item-menu-menu-parent');
    $page->findButton('Save configuration')->click();
    $this->assertSession()->pageTextContains('The configuration options have been saved.');
  }

  /**
   * Test select element is not modified if wrapper classes are not present.
   */
  public function testWrongWrapperClasses() {
    // Check the menu link content form.
    $this->drupalGet('admin/structure/menu/manage/main/add');
    $this->assertSession()->assertNoElementAfterWait('css', '#se_0_0');

    // Check the node form.
    $this->drupalGet('node/add/page');
    $page = $this->getSession()->getPage();

    // Show menu settings.
    $page->findLink('Menu settings')->click();

    // Enable menu item on node form.
    $page->checkField('edit-menu-enabled');
    $this->assertSession()->assertNoElementAfterWait('css', '#se_0_0');
  }

  /**
   * Test with theme-customized CSS selectors.
   */
  public function testCustomizedWrapperClasses() {
    // Update CSS selectors in the settings form.
    $this->testSettingsForm();

    // Check the menu link content form.
    $this->drupalGet('admin/structure/menu/manage/main/add');
    $this->assertSession()->waitForField('se_0_0');
    $this->assertSession()->fieldExists('se_0_0');

    // Check the node form.
    $this->drupalGet('node/add/page');
    $page = $this->getSession()->getPage();

    // Show menu settings.
    $page->findLink('Menu settings')->click();

    // Enable menu item on node form.
    $page->checkField('edit-menu-enabled');
    $this->assertSession()->waitForField('se_0_0');
    $this->assertSession()->fieldExists('se_0_0');
  }

}
