((Drupal) => {

  /**
   * Ajax command for removing a class from matching element(s).
   * @param {Drupal.Ajax} [ajax] An Ajax object.
   * @param {object} response The response object.
   */
  Drupal.AjaxCommands.prototype.mercuryEditorUpdateState = (ajax, response) => {
    if (
      response.stateIndex === undefined ||
      response.stateCount === undefined
    ) {
      return;
    }
    const target = window.frameElement?.id === 'me-preview'
      ? window.parent
      : window;
    target.postMessage({
      type: 'mercuryEditorUpdateState',
      settings: {
        stateIndex: response.stateIndex,
        stateCount: response.stateCount,
      }
    });
  };
})(Drupal, drupalSettings, jQuery, once, Drupal.debounce);
