(function () {
  'use strict';

  ((Drupal) => {
    /**
     * Ajax command for removing a class from matching element(s).
     * @param {Drupal.Ajax} [ajax] An Ajax object.
     * @param {object} response The response object.
     */
    Drupal.AjaxCommands.prototype.mercuryEditorSelectComponent = (ajax, response) => {
      if (response.uuid === undefined) {
        return;
      }
      const previewFrame = document.querySelector('#me-preview')?.contentWindow || window;
      previewFrame.postMessage({
        type: 'componentSelected',
        settings: { uuid: response.uuid },
      });
    };
  })(Drupal);

})();
