<?php

namespace Drupal\mercury_editor\Ajax;

use Drupal\Core\Ajax\BaseCommand;

/**
 * Defines an AJAX command to remove a css class.
 */
class MercuryEditorRemoveClassCommand extends BaseCommand {

  /**
   * Constructs a MercuryEditorAddClassCommand object.
   *
   * @param string $selector
   *   The selector to add the class to.
   * @param string $className
   *   The class name to add.
   */
  public function __construct(
    private string $selector,
    private string $className,
  ) {}

  /**
   * Returns an AJAX command to add a css class.
   */
  public function render() {
    return [
      'command' => 'mercuryEditorRemoveClass',
      'selector' => $this->selector,
      'className' => $this->className,
    ];
  }

}
