<?php

namespace Drupal\mercury_editor;

use Drupal\layout_paragraphs\Utility\Dialog;
use Drupal\Core\Config\ConfigFactoryInterface;

/**
 * Provides dialog options for Mercury Editor Ajax commands.
 *
 * @package Drupal\mercury_editor
 */
class DialogService {

  /**
   * The dialog configuration.
   *
   * @var array
   */
  protected $config;

  /**
   * Service constructor.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $config_factory
   *   The config factory service.
   */
  public function __construct(ConfigFactoryInterface $config_factory) {
    $this->config = $config_factory->get('mercury_editor.settings')->get('dialog_settings');
  }

  /**
   * Returns an array of dialog settings for modal edit forms.
   *
   * @param array $context
   *   The context array.
   *
   * @return array
   *   The modal settings.
   */
  public function dialogSettings(array $context = []) {

    $modal_settings = $this->config['_defaults'];
    if (!empty($context['dock'])) {
      $modal_settings = array_merge($modal_settings, $this->config['_dock_defaults'] ?? []);
      $modal_settings['dock'] = $context['dock'];
      $settings_key = 'dock_' . $context['dialog'];
    }
    else {
      $modal_settings = array_merge($modal_settings, $this->config['_dialog_defaults'] ?? []);
      $settings_key = $context['dialog'];
    }
    if (!empty($settings_key) && !empty($this->config[$settings_key])) {
      $modal_settings = array_merge($modal_settings, $this->config[$settings_key]);
    }
    if (!empty($context['layout'])) {
      $modal_settings['target'] = Dialog::dialogId($context['layout']);
    }
    if (!empty($settings_key) && $settings_key === 'component_menu' && empty($this->config[$settings_key]['width'])) {
      // Set the component menu dialog width to fit-content
      // if not specified.
      $modal_settings['width'] = 'fit-content';
    }

    return $modal_settings ?? [];
  }

}
