(() => {

  let lastActiveElement = null;

  document.addEventListener('dialog:beforecreate', (event) => {
    lastActiveElement = document.activeElement;
  });

  document.addEventListener('dialog:aftercreate', (event) => {
    setTimeout(() => {
      if (
        lastActiveElement &&
        typeof lastActiveElement.focus === 'function' &&
        lastActiveElement.getAttribute('data-keep-focus') === 'true' &&
        lastActiveElement !== document.activeElement
      ) {
        lastActiveElement.focus();
      }
    });
  });


})();
