<?php

namespace Drupal\mercury_editor_page_templates\Theme;

use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Theme\ThemeNegotiatorInterface;

/**
 * Determines the theme for Mercury Editor Page Templates routes.
 */
class ThemeNegotiator implements ThemeNegotiatorInterface {

  /**
   * The config factory service.
   *
   * @var \Drupal\Core\Config\ConfigFactoryInterface
   */
  protected $configFactory;

  /**
   * Constructs a new ThemeNegotiator.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $config_factory
   *   The config factory.
   */
  public function __construct(ConfigFactoryInterface $config_factory) {
    $this->configFactory = $config_factory;
  }

  /**
   * {@inheritDoc}
   */
  public function applies(RouteMatchInterface $route_match) {
    $route_name = $route_match->getRouteName();

    // Apply to template selector routes.
    if (in_array($route_name, [
      'mercury_editor_page_templates.template_selector',
      'mercury_editor_page_templates.content_type_templates',
    ])) {
      return TRUE;
    }

    return FALSE;
  }

  /**
   * {@inheritDoc}
   */
  public function determineActiveTheme(RouteMatchInterface $route_match) {
    $theme = $this->configFactory->get('mercury_editor_page_templates.settings')->get('template_selector_theme');

    if (empty($theme)) {
      $theme = $this->configFactory->get('system.theme')->get('admin');
    }
    if (empty($theme)) {
      $theme = $this->configFactory->get('system.theme')->get('default');
    }
    return $theme;
  }

}
