<?php

namespace Drupal\mermaid_graphapi\Plugin\views\style;

use Drupal\Core\Form\FormStateInterface;
use Drupal\graphapi\Plugin\views\style\Graph;

/**
 * Style plugin to render a view as a graph (without Mermaid plugins).
 *
 * @ViewsStyle(
 *   id = "graphapi_graph",
 *   title = @Translation("Graph"),
 *   help = @Translation("Displays data in a graph."),
 *   theme = "graphapi_view_graph",
 *   display_types = {"normal"}
 * )
 */
class GraphWithoutMermaid extends Graph {

  /**
   * {@inheritdoc}
   */
  public function buildOptionsForm(&$form, FormStateInterface $form_state) {
    parent::buildOptionsForm($form, $form_state);
    $graph_formats = $this->graphFormatManager->getDefinitions();
    // This style plugin should only handle non-Mermaid graphs.
    foreach ($graph_formats as $format_id => $format) {
      if (!array_key_exists($format_id, $form['format_id']['#options'])) {
        continue;
      }
      if ($format['engine'] !== 'mermaid') {
        continue;
      }
      unset($form['format_id']['#options'][$format_id]);
    }
  }

}
