<?php

namespace Drupal\message_filter\Plugin;

use Drupal\Component\Plugin\PluginInspectionInterface;
use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\Core\Session\AccountInterface;

/**
 * Interface for message bypass strategy plugins.
 */
interface MessageBypassStrategyInterface extends PluginInspectionInterface {

  /**
   * Determines if a message should bypass filtering.
   *
   * @param mixed $message
   *   The message to check.
   * @param string $type
   *   The message type.
   * @param \Drupal\Core\Session\AccountInterface $account
   *   The current user account.
   * @param \Drupal\Core\Routing\RouteMatchInterface $route_match
   *   The current route match.
   *
   * @return bool
   *   TRUE if the message should bypass filtering, FALSE otherwise.
   */
  public function shouldBypass($message, $type, AccountInterface $account, RouteMatchInterface $route_match);

  /**
   * Gets the strategy label.
   *
   * @return string
   *   The strategy label.
   */
  public function getLabel();

  /**
   * Gets the strategy description.
   *
   * @return string
   *   The strategy description.
   */
  public function getDescription();

}
