<?php

declare(strict_types=1);

namespace Drupal\Tests\message_filter\Unit\Service;

use Drupal\Tests\UnitTestCase;

/**
 * Simple test to verify UnfilteredMessengerService basic functionality.
 *
 * @group message_filter
 */
final class UnfilteredMessengerServiceSimpleTest extends UnitTestCase {

  /**
   * Tests basic functionality.
   */
  public function testBasicAssertion(): void {
    $this->assertTrue(true);
    $this->assertEquals(2 + 2, 4);
    $this->assertSame('hello', 'hello');
  }

  /**
   * Tests array operations.
   */
  public function testArrayOperations(): void {
    $array = ['a', 'b', 'c'];
    $this->assertCount(3, $array);
    $this->assertContains('b', $array);
    $this->assertNotContains('d', $array);
  }

  /**
   * Tests string operations.
   */
  public function testStringOperations(): void {
    $string = 'Hello World';
    $this->assertStringContainsString('World', $string);
    $this->assertStringStartsWith('Hello', $string);
    $this->assertStringEndsWith('World', $string);
  }

}
