<?php

namespace Drupal\message_filter\Annotation;

use Drupal\Component\Annotation\Plugin;

/**
 * Defines a Message Bypass Strategy annotation object.
 *
 * @see \Drupal\message_filter\Plugin\MessageBypassStrategyManager
 * @see plugin_api
 *
 * @Annotation
 */
class MessageBypassStrategy extends Plugin {

  /**
   * The plugin ID.
   *
   * @var string
   */
  public $id;

  /**
   * The label of the strategy.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $label;

  /**
   * The description of the strategy.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $description;

  /**
   * The weight of the strategy (used for sorting).
   *
   * @var int
   */
  public $weight = 0;

}
