<?php

namespace Drupal\message_filter\Plugin\MessageBypassStrategy;

use Drupal\Core\Plugin\PluginBase;
use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\message_filter\Plugin\MessageBypassStrategyInterface;

/**
 * Custom bypass strategy for demonstration.
 *
 * @MessageBypassStrategy(
 *   id = "demo_bypass",
 *   label = @Translation("Demo Bypass Strategy"),
 *   description = @Translation("Strategy for testing and demonstration purposes."),
 *   weight = 5
 * )
 */
class DemoBypassStrategy extends PluginBase implements MessageBypassStrategyInterface {

  /**
   * {@inheritdoc}
   */
  public function shouldBypass($message, $type, AccountInterface $account, RouteMatchInterface $route_match) {
    // Bypass pour les messages contenant "DEMO"
    if (is_string($message) && strpos(strtoupper($message), 'DEMO') !== FALSE) {
      \Drupal::service('logger.factory')->get('message_filter')->info('Demo bypass triggered for message: @message', ['@message' => $message]);
      return TRUE;
    }

    // Bypass pour les utilisateurs avec un nom contenant "test"
    $username = $account->getAccountName();
    if (strpos(strtolower($username), 'test') !== FALSE) {
      \Drupal::service('logger.factory')->get('message_filter')->info('Demo bypass triggered for test user: @user', ['@user' => $username]);
      return TRUE;
    }

    // Bypass sur les pages de configuration (routes admin.*)
    $route_name = $route_match->getRouteName();
    if ($route_name && strpos($route_name, 'admin') !== FALSE) {
      \Drupal::service('logger.factory')->get('message_filter')->info('Demo bypass triggered for admin route: @route', ['@route' => $route_name]);
      return TRUE;
    }

    // Bypass le vendredi (pour l'exemple !)
    if (date('N') == 5) { // 5 = vendredi
      \Drupal::service('logger.factory')->get('message_filter')->info('Demo bypass triggered - it\'s Friday!');
      return TRUE;
    }

    return FALSE;
  }

  /**
   * {@inheritdoc}
   */
  public function getLabel() {
    return $this->pluginDefinition['label'];
  }

  /**
   * {@inheritdoc}
   */
  public function getDescription() {
    return $this->pluginDefinition['description'];
  }

}
