<?php

namespace Drupal\message_filter\Plugin\MessageBypassStrategy;

use Drupal\Core\Plugin\PluginBase;
use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\message_filter\Plugin\MessageBypassStrategyInterface;

/**
 * Example bypass strategy that allows admin users to see all messages.
 *
 * @MessageBypassStrategy(
 *   id = "example_bypass",
 *   label = @Translation("Example Bypass Strategy"),
 *   description = @Translation("Example strategy that bypasses filtering for admin users."),
 *   weight = 0
 * )
 */
class ExampleBypassStrategy extends PluginBase implements MessageBypassStrategyInterface {

  /**
   * {@inheritdoc}
   */
  public function shouldBypass($message, $type, AccountInterface $account, RouteMatchInterface $route_match) {
    // Example: Always bypass for user 1 (admin).
    if ($account->id() == 1) {
      return TRUE;
    }

    // Example: Bypass for specific message patterns.
    if (is_string($message) && strpos($message, 'IMPORTANT:') === 0) {
      return TRUE;
    }

    // Example: Bypass on admin routes.
    $route_name = $route_match->getRouteName();
    if ($route_name && strpos($route_name, 'system.admin') === 0) {
      return TRUE;
    }

    return FALSE;
  }

  /**
   * {@inheritdoc}
   */
  public function getLabel() {
    return $this->pluginDefinition['label'];
  }

  /**
   * {@inheritdoc}
   */
  public function getDescription() {
    return $this->pluginDefinition['description'];
  }

}
