<?php

namespace Drupal\message_filter\Plugin;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;

/**
 * Plugin manager for message bypass strategies.
 */
class MessageBypassStrategyManager extends DefaultPluginManager {

  /**
   * Constructs a MessageBypassStrategyManager object.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler to invoke the alter hook with.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct(
      'Plugin/MessageBypassStrategy',
      $namespaces,
      $module_handler,
      'Drupal\message_filter\Plugin\MessageBypassStrategyInterface',
      'Drupal\message_filter\Annotation\MessageBypassStrategy'
    );

    $this->alterInfo('message_bypass_strategy_info');
    $this->setCacheBackend($cache_backend, 'message_bypass_strategy_plugins');
  }

}
