<?php

declare(strict_types=1);

namespace Drupal\message_filter\Factory;

use Drupal\Core\Messenger\MessengerInterface;

/**
 * Interface for messenger factory.
 *
 * This factory helps avoid circular dependencies when services need
 * to access the messenger but can't inject it directly due to decoration.
 */
interface MessengerFactoryInterface {

  /**
   * Gets the messenger service.
   *
   * @return \Drupal\Core\Messenger\MessengerInterface
   *   The messenger service.
   */
  public function getMessenger(): MessengerInterface;

}
