<?php

declare(strict_types=1);

namespace Drupal\message_filter\Service;

use Drupal\Core\Session\AccountInterface;

/**
 * Interface for message filtering configuration service.
 */
interface MessageFilterConfigurationInterface {

  /**
   * Checks if message filtering is enabled.
   *
   * @return bool
   *   TRUE if filtering is enabled.
   */
  public function isFilteringEnabled(): bool;

  /**
   * Gets role-based rules for a user.
   *
   * @param \Drupal\Core\Session\AccountInterface $account
   *   The user account.
   *
   * @return array
   *   Array of applicable role rules sorted by priority.
   */
  public function getRoleRulesForUser(AccountInterface $account): array;

  /**
   * Gets global configuration.
   *
   * @return array
   *   Global configuration array.
   */
  public function getGlobalConfiguration(): array;

}
