<?php

declare(strict_types=1);

namespace Drupal\message_filter\Service;

use Drupal\Core\Session\AccountInterface;

/**
 * Interface for message filtering rules evaluation.
 */
interface MessageFilterRuleEvaluatorInterface {

  /**
   * Evaluates if a message should be blocked based on rules.
   *
   * @param mixed $message
   *   The message to evaluate.
   * @param string $type
   *   The message type.
   * @param \Drupal\Core\Session\AccountInterface $account
   *   The user account.
   * @param array $rules
   *   Array of role rules to evaluate.
   *
   * @return bool
   *   TRUE if the message should be blocked.
   */
  public function shouldBlockMessage($message, string $type, AccountInterface $account, array $rules): bool;

}
