<?php

namespace Drupal\message_filter\Service;

/**
 * Interface for URL matching services.
 */
interface UrlMatcherServiceInterface {

  /**
   * Checks if the current URL matches any of the given patterns.
   *
   * @param array $patterns
   *   Array of URL patterns to match against.
   *
   * @return bool
   *   TRUE if current URL matches any pattern, FALSE otherwise.
   */
  public function matchesAnyPattern(array $patterns): bool;

  /**
   * Checks if a URL path matches a pattern (with wildcard support).
   *
   * @param string $current_path
   *   The current URL path.
   * @param string $pattern
   *   The pattern to match against (supports * wildcards).
   *
   * @return bool
   *   TRUE if the path matches the pattern, FALSE otherwise.
   */
  public function matchesPattern(string $current_path, string $pattern): bool;

}
