<?php

/**
 * @file
 * Bootstrap file for PHPUnit tests.
 */

use Drupal\Core\DrupalKernel;
use Drupal\Core\Site\Settings;
use Symfony\Component\HttpFoundation\Request;

// Composer autoloader
$autoloader = require_once __DIR__ . '/../vendor/autoload.php';

// Drupal constants configuration for tests
if (!defined('DRUPAL_ROOT')) {
  define('DRUPAL_ROOT', realpath(__DIR__ . '/../web'));
}

// Test environment configuration
$request = Request::createFromGlobals();
$kernel = DrupalKernel::createFromRequest($request, $autoloader, 'testing');

// Settings initialization for tests
if (!class_exists(Settings::class)) {
  require_once DRUPAL_ROOT . '/core/lib/Drupal/Core/Site/Settings.php';
}

// Base configuration for tests
$settings = [
  'databases' => [
    'default' => [
      'default' => [
        'database' => getenv('SIMPLETEST_DB') ?: 'drupal_test',
        'username' => 'drupal',
        'password' => 'drupal',
        'prefix' => '',
        'host' => 'mysql',
        'port' => '3306',
        'namespace' => 'Drupal\\Core\\Database\\Driver\\mysql',
        'driver' => 'mysql',
      ],
    ],
  ],
  'hash_salt' => 'test-hash-salt-for-phpunit',
  'file_public_path' => 'sites/default/files',
  'file_private_path' => '/tmp/drupal_private',
];

new Settings($settings);

// Drupal environment initialization for tests
$kernel->boot();
$kernel->preHandle($request);
