
# Message Filter 2.1.0

**Release Date**: August 23, 2025
**Compatibility**: Drupal 10.x, 11.x
**PHP Version**: 8.1+

## Refactoring & Improvements

### 🧩 SOLID Refactoring & Dependency Injection
- Refactoring complet du module selon les principes SOLID (SRP, OCP, LSP, ISP, DIP)
- Découpage en services spécialisés, injection de toutes les dépendances (plus d'appel statique)
- Suppression des dépendances circulaires, usage de factory pour Messenger
- Respect total des bonnes pratiques Drupal 10/11

### 🧪 Tests unitaires renforcés
- Couverture complète des services, décorateurs et plugins
- 52 tests unitaires, 96 assertions, 100% de réussite
- Correction des tests pour la nouvelle signature des constructeurs

### 🛡️ Compatibilité et robustesse
- Compatible PHP 8.1+
- Validation sur Drupal 10 et 11
- Documentation et exemples de configuration mis à jour

# Message Filter 2.0.0

**Release Date**: August 17, 2025
**Compatibility**: Drupal 10.x, 11.x
**PHP Version**: 8.1+

## What's New

### 🎯 Advanced Message Filtering System
- **Role-based filtering** with granular control per user role
- **Route and URL pattern matching** with wildcard support (/admin/*)
- **Message type filtering** (status, warning, error) with selective display
- **Priority system** for rule conflict resolution

### 🏗️ Enterprise Architecture
- **Decorator pattern** implementation for clean service interception
- **Plugin system** for extensible bypass strategies
- **Unfiltered messenger API** for critical messages
- **Full dependency injection** support

### 🔧 Developer Features
- **Comprehensive API** with 10+ service methods
- **Custom hooks** for advanced filtering logic
- **Plugin annotations** for easy strategy development
- **Configuration schema** with full YAML support

## Technical Highlights

### Code Quality
```
✓ 29 Unit Tests, 71 Assertions
✓ 100% Pass Rate
✓ PHPStan Level 8 Compliance
✓ Drupal Coding Standards
✓ PHP 8.1+ Strict Types
```

### Performance
- **Lightweight**: Minimal overhead with smart caching
- **Scalable**: Optimized for high-traffic environments
- **Memory efficient**: Static caching prevents redundant processing

## Installation

### Quick Install
```bash
# Enable module
drush en message_filter

# Configure
drush config-set message_filter.settings enabled 1
```

### Manual Install
1. Extract to `modules/custom/message_filter`
2. Enable at `/admin/modules`
3. Configure at `/admin/config/system/message-filter`

## Key Features

### 🎭 Role-Based Filtering
```php
// Different rules for different roles
$config['role_rules']['editor'] = [
  'enabled' => TRUE,
  'blocked_message_types' => ['status'],
  'blocked_routes' => ['node.add'],
  'priority' => 10,
];
```

### 🚨 Unfiltered Messages API
```php
// Critical messages that bypass all filters
$unfiltered = \Drupal::service('message_filter.unfiltered_messenger');
$unfiltered->addMessage('System maintenance in 5 minutes', 'warning');
```

### 🔌 Custom Bypass Strategies
```php
/**
 * @MessageBypassStrategy(
 *   id = "emergency_bypass",
 *   label = @Translation("Emergency Messages"),
 *   weight = 15
 * )
 */
class EmergencyBypass implements MessageBypassStrategyInterface {
  public function shouldBypass($message, $type, $account, $route_match) {
    return preg_match('/URGENT|CRITICAL/', $message);
  }
}
```

## Configuration Options

### Permissions
- `administer message filter`: Access configuration interface
- `bypass message filter`: Override all filtering rules

### Default Settings
- **Filtering**: Disabled by default
- **Admin bypass**: Enabled for user role 1
- **Logging**: Optional filtered message logging

## Migration & Compatibility

### New Installation
- No migration required
- Default configuration provided
- Zero-configuration operation

### Drupal Compatibility
- **Drupal 10.0+**: Full support
- **Drupal 11.0+**: Full support
- **PHP 8.1+**: Required minimum
- **PHP 8.3**: Fully tested

## What's Next

### Version 2.1.0 (Q4 2025)
- Advanced plugin management UI
- Configuration import/export
- Enhanced debugging tools
- Performance optimizations

### Version 2.2.0 (Q1 2026)
- JavaScript message filtering
- Real-time validation
- Visual rule builder
- External logging integration

## Support

### Documentation
- **README**: Complete architecture guide
- **API Docs**: Full method documentation
- **Examples**: Plugin development guide
- **CI/CD**: Pipeline documentation

### Community
- **Issue Queue**: [drupal.org/project/issues/message_filter](https://www.drupal.org/project/issues/message_filter)
- **Forums**: Community support available
- **Security**: Regular security updates

## Download

- **Package**: [message_filter-2.0.0.tar.gz](https://www.drupal.org/project/message_filter/releases/2.0.0)
- **Source**: [Git Repository](https://git.drupalcode.org/project/message_filter)
- **Documentation**: [README](https://git.drupalcode.org/project/message_filter/-/blob/2.x/README.md)

---

**License**: GPL-2.0+ | **Maintainer**: Drupal Community | **Security**: No known vulnerabilities
