<?php

namespace Drupal\message_filter\Service;

/**
 * Interface for message filtering services.
 */
interface MessageFilterServiceInterface {

  /**
   * Determines if a message should be blocked.
   *
   * @param mixed $message
   *   The message to check.
   * @param string $type
   *   The message type.
   *
   * @return bool
   *   TRUE if the message should be blocked, FALSE otherwise.
   */
  public function shouldBlockMessage($message, string $type): bool;

  /**
   * Checks if the module is enabled.
   *
   * @return bool
   *   TRUE if filtering is enabled, FALSE otherwise.
   */
  public function isFilteringEnabled(): bool;

}
