<?php

declare(strict_types=1);

namespace Drupal\message_filter\Service;

/**
 * Interface for URL pattern matching service.
 */
interface UrlMatcherInterface {

  /**
   * Checks if a URL path matches a pattern.
   *
   * @param string $path
   *   The URL path to check.
   * @param string $pattern
   *   The pattern to match against (supports wildcards).
   *
   * @return bool
   *   TRUE if the path matches the pattern.
   */
  public function matches(string $path, string $pattern): bool;

  /**
   * Checks if a path matches any of the given patterns.
   *
   * @param string $path
   *   The URL path to check.
   * @param array $patterns
   *   Array of patterns to match against.
   *
   * @return bool
   *   TRUE if the path matches any pattern.
   */
  public function matchesAny(string $path, array $patterns): bool;

}
