<?php

namespace Drupal\message_filter\Service;

use Symfony\Component\HttpFoundation\RequestStack;

/**
 * Service for matching URL patterns.
 */
class UrlMatcherService implements UrlMatcherServiceInterface {

  /**
   * The request stack.
   *
   * @var \Symfony\Component\HttpFoundation\RequestStack
   */
  protected $requestStack;

  /**
   * Constructs a UrlMatcherService object.
   *
   * @param \Symfony\Component\HttpFoundation\RequestStack $request_stack
   *   The request stack.
   */
  public function __construct(RequestStack $request_stack) {
    $this->requestStack = $request_stack;
  }

  /**
   * {@inheritdoc}
   */
  public function matchesAnyPattern(array $patterns): bool {
    $request = $this->requestStack->getCurrentRequest();
    if (!$request) {
      return FALSE;
    }

    $current_path = $request->getPathInfo();

    foreach ($patterns as $pattern) {
      if ($this->matchesPattern($current_path, $pattern)) {
        return TRUE;
      }
    }

    return FALSE;
  }

  /**
   * {@inheritdoc}
   */
  public function matchesPattern(string $current_path, string $pattern): bool {
    // Convert wildcard pattern to regex pattern.
    $regex_pattern = '/^' . str_replace(['/', '*'], ['\/', '.*'], $pattern) . '$/';
    
    return (bool) preg_match($regex_pattern, $current_path);
  }

}
