<?php

namespace Drupal\messages\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configuration form for Enhanced Status Messages module.
 */
class EnhancedStatusMessagesConfigForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['enhanced_status_messages.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'enhanced_status_messages_config_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('enhanced_status_messages.settings');

    $form['display_settings'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('Display Settings'),
      '#collapsible' => FALSE,
      '#collapsed' => FALSE,
    ];

    $form['display_settings']['auto_hide_time'] = [
      '#type' => 'select',
      '#title' => $this->t('Auto-hide time'),
      '#description' => $this->t('How long to display the message before automatically hiding it.'),
      '#default_value' => $config->get('auto_hide_time') ?? 5000,
      '#options' => [
        3000 => $this->t('3 seconds'),
        5000 => $this->t('5 seconds'),
        7000 => $this->t('7 seconds'),
        10000 => $this->t('10 seconds'),
        15000 => $this->t('15 seconds'),
        0 => $this->t('Never (manual close only)'),
      ],
    ];

    $form['display_settings']['position'] = [
      '#type' => 'select',
      '#title' => $this->t('Message position'),
      '#description' => $this->t('Where to display the status messages on the page.'),
      '#default_value' => $config->get('position') ?? 'top-right',
      '#options' => [
        'top-right' => $this->t('Top Right'),
        'top-left' => $this->t('Top Left'),
        'top-center' => $this->t('Top Center'),
        'bottom-right' => $this->t('Bottom Right'),
        'bottom-left' => $this->t('Bottom Left'),
        'bottom-center' => $this->t('Bottom Center'),
      ],
    ];

    $form['display_settings']['enable_animations'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable animations'),
      '#description' => $this->t('Enable smooth fade in/out animations for messages.'),
      '#default_value' => $config->get('enable_animations') ?? TRUE,
    ];

    $form['display_settings']['show_wave_background'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Show wave background'),
      '#description' => $this->t('Display decorative wave background in message cards.'),
      '#default_value' => $config->get('show_wave_background') ?? TRUE,
    ];

    $form['message_types'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('Message Type Settings'),
      '#collapsible' => FALSE,
      '#collapsed' => FALSE,
    ];

    $form['message_types']['enable_success'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable enhanced success messages'),
      '#default_value' => $config->get('enable_success') ?? TRUE,
    ];

    $form['message_types']['enable_warning'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable enhanced warning messages'),
      '#default_value' => $config->get('enable_warning') ?? TRUE,
    ];

    $form['message_types']['enable_error'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable enhanced error messages'),
      '#default_value' => $config->get('enable_error') ?? TRUE,
    ];

    $form['message_types']['enable_info'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable enhanced info messages'),
      '#default_value' => $config->get('enable_info') ?? TRUE,
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('enhanced_status_messages.settings')
      ->set('auto_hide_time', $form_state->getValue('auto_hide_time'))
      ->set('position', $form_state->getValue('position'))
      ->set('enable_animations', $form_state->getValue('enable_animations'))
      ->set('show_wave_background', $form_state->getValue('show_wave_background'))
      ->set('enable_success', $form_state->getValue('enable_success'))
      ->set('enable_warning', $form_state->getValue('enable_warning'))
      ->set('enable_error', $form_state->getValue('enable_error'))
      ->set('enable_info', $form_state->getValue('enable_info'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
