# Enhanced Status Messages Installation

## Requirements

- Drupal 9.2+ (for `core/once` dependency)
- PHP 7.4+
- Modern browser with CSS Grid support

## Installation Methods

### Method 1: Manual Installation

1. Download and extract the module files
2. Place in your `modules/contrib/` directory:
   ```bash
   /path/to/drupal/modules/contrib/enhanced_status_messages/
   ```
3. Enable the module:
   ```bash
   drush en enhanced_status_messages
   ```
4. Clear caches:
   ```bash
   drush cr
   ```

### Method 2: Composer Installation (Recommended)

```bash
composer require drupal/enhanced_status_messages
drush en enhanced_status_messages
drush cr
```

### Method 3: Drush Installation

```bash
drush dl enhanced_status_messages
drush en enhanced_status_messages
drush cr
```

## Configuration

1. Navigate to **Administration → Configuration → User Interface → Enhanced Status Messages**
2. Or visit: `/admin/config/user-interface/enhanced-status-messages`
3. Configure your preferred settings:
   - Auto-hide timer
   - Message position
   - Animation settings
   - Wave background display
   - Enable/disable specific message types

## Verification

1. Create a test message by visiting any form and submitting it
2. Or use the admin configuration form to save settings
3. You should see the enhanced card-based messages appear

## Troubleshooting

If messages don't appear enhanced:

1. **Check module status:**
   ```bash
   drush pm:list | grep enhanced_status_messages
   ```

2. **Clear all caches:**
   ```bash
   drush cr
   ```

3. **Check permissions:**
   - Ensure your user has "View site reports" permission
   - Check file permissions on module directory

4. **Browser compatibility:**
   - Ensure you're using a supported browser
   - Check browser console for JavaScript errors

5. **Theme conflicts:**
   - Test with a default theme (Olivero/Claro)
   - Check for CSS conflicts in your custom theme

## Uninstallation

```bash
drush pmu enhanced_status_messages
```

This will remove the module and its configuration.
