<?php

namespace Drupal\messages\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configuration form for Enhanced Status Messages module.
 */
class EnhancedStatusMessagesConfigForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['messages.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'messages_config_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {

    $form['display_settings'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('Display settings'),
    ];

    $form['display_settings']['auto_hide_time'] = [
      '#type' => 'select',
      '#title' => $this->t('Auto-hide time'),
      '#description' => $this->t('How long to display the message before automatically hiding it.'),
      '#options' => [
        3000 => $this->t('3 seconds'),
        5000 => $this->t('5 seconds'),
        7000 => $this->t('7 seconds'),
        10000 => $this->t('10 seconds'),
        15000 => $this->t('15 seconds'),
        0 => $this->t('Never (manual close only)'),
      ],
      '#config_target' => 'messages.settings:auto_hide_time',
    ];

    $form['display_settings']['position'] = [
      '#type' => 'select',
      '#title' => $this->t('Message position'),
      '#description' => $this->t('Where to display the status messages on the page.'),
      '#options' => [
        'top-right' => $this->t('Top right'),
        'top-left' => $this->t('Top left'),
        'top-center' => $this->t('Top center'),
        'bottom-right' => $this->t('Bottom right'),
        'bottom-left' => $this->t('Bottom left'),
        'bottom-center' => $this->t('Bottom center'),
      ],
      '#config_target' => 'messages.settings:position',
    ];

    $form['display_settings']['enable_animations'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable animations'),
      '#description' => $this->t('Enable smooth fade in/out animations for messages.'),
      '#config_target' => 'messages.settings:enable_animations',
    ];

    $form['display_settings']['show_wave_background'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Show wave background'),
      '#description' => $this->t('Display decorative wave background in message cards.'),
      '#config_target' => 'messages.settings:show_wave_background',
    ];

    $form['message_types'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('Message type settings'),
    ];

    $form['message_types']['enable_success'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable enhanced success messages'),
      '#config_target' => 'messages.settings:enable_success',
    ];

    $form['message_types']['enable_warning'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable enhanced warning messages'),
      '#config_target' => 'messages.settings:enable_warning',
    ];

    $form['message_types']['enable_error'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable enhanced error messages'),
      '#config_target' => 'messages.settings:enable_error',
    ];

    $form['message_types']['enable_info'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable enhanced info messages'),
      '#config_target' => 'messages.settings:enable_info',
    ];

    return parent::buildForm($form, $form_state);
  }

}
